-- Medit Functions Script
-- meditUtilities Structure
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

/* History

Feb  2005 -  split the functions from the MeditUtilities into this script to make them re-usable
June 2006 -  added functions for the mrArchMtl templates 

NOTE TO LOCALIZATION

Nothing should be localized in this script

*/

struct meditUtilities (


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultsFile =
(
	defaultsFolder = getDir #defaults
	defaultsFile = defaultsFolder + #'\\CurrentDefaults.INI' as string
	if (getFiles defaultsFile).count == 0 do
		defaultsFile = defaultsFolder + #'\\FactoryDefaults\\CurrentDefaults.INI' as string
	if (getFiles defaultsFile).count == 0 then 
		undefined 
	else 
		defaultsFile
),
-- end getDefaultsFile
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultLibraryFile =
(
	defaultsFolder = getDir #defaults
	defaultLibFile = defaultsFolder + #'\\medit.mat' as string
	if (getFiles defaultLibFile).count == 0 do
		defaultLibFile = defaultsFolder + #'\\FactoryDefaults\\medit.mat' as string
	if (getFiles defaultLibFile).count == 0 then 
		undefined 
	else 
		defaultLibFile
),
-- end getDefaultLibraryFile
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn getDefaultMaterial defaultsFileStr =
(
-- this is obsolete: still maybe used.
-- return material created from the class of the first element in the default library
-- parameter is not uded.
	defaultMtl = StandardMaterial

	defaultMtlLibFile = meditUtilities.getDefaultLibraryFile()
	if defaultMtlLibFile != undefined do
	(
		defaultMtlLib = loadTempMaterialLibrary defaultMtlLibFile
		if defaultMtlLib.count >= 1 do
			defaultMtl = (classof defaultMtlLib[1])()
	)

	defaultMtl
),
-- end getDefaultMaterial
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

fn isMaterialInUse mtl =
(
	local foundSceneRef = false
	if superClassof mtl == material or superClassof mtl == textureMap do
	(
		local deps = refs.dependents mtl
		for i in deps while not foundSceneRef do
		(
			local c = classof i
			local sc = superclassof i
			local sid = i.superclassid
			-- exclude scene root, scene mtl lib, medit, materials, texturemaps, and texture map containers (used by std mtl to hold texmaps)
			foundSceneRef = c != Scene and c != MtlBaseLib and c != Material_Editor and sc != Material and sc != TextureMap and sid != 4224
		)
	)
	foundSceneRef 	
),
-- end isMaterialInUse
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib
-- Get a Material Name and loads each properties into the global mrArchTemplate_ActiveMaterial
-- Used by the mrArchMaterial templates drop down
-- material name defined in the /plugcfg/mrArchMaterial.ini file


fn Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib mrArchTemplate_ActiveMaterial strMtlName =
(
	local matFromLib	
	matFromLib = (loadTempMaterialLibrary ((getdir #maxroot) + "\\materiallibraries\\mrArch_DesignTemplates.mat"))[strMtlName]

	undo on
	(
		for i in getPropNames(matFromLib) do
		(
			local j = (getProperty matFromLib i)
			try (
				SetProperty mrArchTemplate_ActiveMaterial i j
			)
			catch (
				-- Do nothing, normal for a read-only property
			)
		)
	)
	
),
--end Set_mrArchTemplate_ActiveMaterial_FromMaterialInMatlib
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

-- Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib
-- Get a Material Name and loads each properties into the passed material
-- Used by the Physical Material templates drop down
-- material name defined in the /plugcfg/PhysicalMaterial.ini file

fn Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib mtl strMtlName =
(
	local matFromLib	
	matFromLib = (loadTempMaterialLibrary ((getdir #maxroot) + "\\materiallibraries\\PhysicalMaterialTemplates.mat"))[strMtlName]

	undo on
	(
		for i in getPropNames(matFromLib) do
		(
			local j = (getProperty matFromLib i)
			try (
				SetProperty mtl i j
			)
			catch (
				-- Do nothing, normal for a read-only property
			)
		)
	)
	
)--end Set_PhysicalTemplate_ActiveMaterial_FromMaterialInMatlib
--||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||




) -- end struct
